/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package college;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/**
 *
 * @author Administrator
 */
public class FileOpener {
    String filename;
    boolean writeable;
    boolean appendable;
    static File file = null;
    
    @SuppressWarnings("empty-statement")
    public FileOpener(String filename, boolean writeable, boolean appendable) throws FileOpenerException {
        
        this.filename = filename;
        this.writeable = writeable;
        this.appendable = appendable;
        
        file = new File(filename);

        testFile(file, writeable, appendable);
    }

    public FileOpener(boolean writeable, boolean appendable) throws FileOpenerException {
        JFileChooser writechooser = new JFileChooser("Choose or enter a filename:");
        if (writeable == true) {
            if (writechooser.showSaveDialog(null) == JFileChooser.APPROVE_OPTION) {
                file = writechooser.getSelectedFile();
            }
        }
        else {
            if (writechooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
                file = writechooser.getSelectedFile();
            }
        }
        
        testFile(file, writeable, appendable);
    }

    /** This is a helper class that allows us to put all the testing into one
     * method.
     * @param file
     * @param writeable
     * @param appendable
     * @throws college.FileOpenerException
     */
    private void testFile(File file, boolean writeable, boolean appendable) throws FileOpenerException {
        this.writeable = writeable;
        this.appendable = appendable;
        
        //Check for problems with files for reading
        if (!file.exists() && writeable == false) fail("No such source file: " + file.toString());
        if (file.exists() && writeable == false) {
            if (!file.canRead()) fail("Source file is unreadable: " + file.toString());
        }
        
        //Check for problems with files for writing
        if (file.exists() && writeable == true) {
            if (!file.canWrite()) fail("Destination file is unwriteable: " + file.toString());
            else if (appendable == false) {
                //Ask to overwrite existing file
                String response = JOptionPane.showInputDialog("Overwrite existing file? (Y/N)");
                if (!response.equals("Y") && !response.equals("y")) fail("Existing file was not overwritten.");
            }
        }
        
        //Check for other generic problems with files    
        if (file.isDirectory()) fail("Can't use directory: " + file.toString() + " as a file.");
        
        
    }
    
    /** A convenience method to throw an exception upon failure */
    private void fail(String msg) throws FileOpenerException {
        file = null;
        throw new FileOpenerException(msg);
    }
    
    /**
     * 
     * @return 
     */
    protected File checkFile() {
        return file;
    }
}
